<?php
/******************************************************************************
*                                                                             *
*           Copyright (c) 2004-2007 CS-Cart.com. All rights reserved.         *
*                                                                             *
*******************************************************************************
*                                                                             *
* CS-Cart  is  commercial  software,  only  users  who have purchased a valid *
* license through  http://www.cs-cart.com/  and  accept  to the terms of this *
* License Agreement can install this product.                                 *
*                                                                             *
*******************************************************************************
* THIS  CS-CART  SHOP END-USER LICENSE AGREEMENT IS A LEGAL AGREEMENT BETWEEN *
* YOU  AND  YOUR  COMPANY  (COLLECTIVELY, "YOU") AND CS-CART.COM (HEREINAFTER *
* REFERRED  TO  AS  "THE AUTHOR")  FOR THE SOFTWARE PRODUCT IDENTIFIED ABOVE, *
* WHICH INCLUDES COMPUTER  SOFTWARE AND MAY INCLUDE ASSOCIATED MEDIA, PRINTED *
* MATERIALS,  AND  "ONLINE"  OR  ELECTRONIC  DOCUMENTATION (COLLECTIVELY, THE *
* "SOFTWARE").  BY  USING  THE  SOFTWARE,  YOU  SIGNIFY YOUR AGREEMENT TO ALL *
* TERMS, CONDITIONS, AND NOTICES CONTAINED  OR  REFERENCED HEREIN. IF YOU ARE *
* NOT  WILLING  TO  BE  BOUND  BY  THIS  AGREEMENT, DO NOT INSTALL OR USE THE *
* SOFTWARE.                                                                   *
*                                                                             *
* PLEASE READ THE FULL  TEXT OF SOFTWARE LICENSE AGREEMENT IN THE "COPYRIGHT" *
* FILE PROVIDED WITH THIS  DISTRIBUTION. THE AGREEMENT TEXT IS ALSO AVAILABLE *
* AT THE FOLLOWING URL: http://www.cs-cart.com/license.html                   *
******************************************************************************/

//
// $Id: realex3.php Thu Jul 10 17:02:51 GMT+03:00 2008 mestny $
//

global $cart_language;

switch ($order_info['payment_info']['card']) {
	case 'vis': $card_type = 'VISA'; break;
	case 'vie': $card_type = 'ELECTRON'; break;
	case 'mcd': $card_type = 'MASTERCARD'; break;
	case 'amx': $card_type = 'AMEX'; break;
	case 'jsb': $card_type = 'JCB'; break;
	case 'dnc': $card_type = 'DINERS'; break;
	case 'sol': $card_type = 'SOLO'; break;
	case 'swi': $card_type = 'UK MAESTRO'; break;
	case 'lsr': $card_type = 'LASER'; break;
}

$_order_id = ($order_info['repaid']) ? ($order_id .'_'. $order_info['repaid']) : $order_id;
$expiry_date = $order_info['payment_info']['expiry_month'] . $order_info['payment_info']['expiry_year'];

$test = ($payment_data['processor_params']['test'] == '1' ? true : false);
$avs = ($payment_data['processor_params']['avs'] == '1' ? true : false);
$cvv = $order_info['payment_info']['cvv2'];

require_once('worldnettps_files/worldnet_tps_xml.php');

$sale = new XmlAuthRequest($processor_data['params']['terminal_id'],$_order_id,$processor_data['params']['currency'],$order_info['total'],$order_info['payment_info']['card_number'],$card_type);
$sale->SetNonSecureCardCardInfo($expiry_date,$order_info['payment_info']['cardholder_name']);

if($processor_data['params']['sendworldnetmail'] == "1") $sale->SetEmail($order_info['email']);
if($cvv!="") $sale->SetCvv($cvv);
if($avs) {
		$address1 = $order_info['b_address'];
		$address2 = $order_info['b_city'] . $order_info['b_state'];
		$postcode = $order_info['b_zipcode'];

		$sale->SetAvs($address1,$address2,$postcode);
}

// Perform Auth
$response = $sale->ProcessRequest($processor_data['params']['shared_secret'],($processor_data['params']['test'] == "1" ? true : false));

// Verify response hash
$hash = md5($processor_data['params']['terminal_id'] . $_order_id . $order_info['total'] . $response->DateTime() . $response->ResponseCode() . $response->ResponseText() . $processor_data['params']['shared_secret']);

$pp_response = array();
if ($response->IsError()) {
		$pp_response['order_status'] = "D";
		$pp_response["reason_text"] = $response->ErrorString();
} elseif($response->Hash()!=$hash) {
		$pp_response['order_status'] = "D";
		$pp_response["reason_text"] = "An error occured. Error details: Request and Response hash do not match.";
} else {
		$pp_response['order_status'] = ($response->ResponseCode() == "A" ? "P" : "D");
		$pp_response["reason_text"] = $response->ResponseText();
}

fn_finish_payment($order_id, $pp_response, false);
fn_order_placement_routines($order_info['order_id']);

?>
