<?php
/*
* 2007-2011 PrestaShop 
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2011 PrestaShop SA
*  @version  Release: $Revision: 9271 $
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;

class WorldNetHPP extends PaymentModule
{
	private $_ignoreKeyList = array('secure_key');

	public function __construct()
	{
		$this->name = 'worldnethpp';
		$this->tab = 'payments_gateways';
		$this->version = '1.0';

		parent::__construct();

		$this->displayName = 'WorldNet TPS Secure Payments';
		$this->description = 'Allows PCI compliant payments through a redirect the WorldNet Hosted Payment Page';

		/* For 1.4.3 and less compatibility */
		$updateConfig = array('PS_OS_CHEQUE', 'PS_OS_PAYMENT', 'PS_OS_PREPARATION', 'PS_OS_SHIPPING', 'PS_OS_CANCELED', 'PS_OS_REFUND', 'PS_OS_ERROR', 'PS_OS_OUTOFSTOCK', 'PS_OS_BANKWIRE', 'PS_OS_PAYPAL', 'PS_OS_WS_PAYMENT');
		if (!Configuration::get('PS_OS_PAYMENT'))
			foreach ($updateConfig as $u)
				if (!Configuration::get($u) && defined('_'.$u.'_'))
					Configuration::updateValue($u, constant('_'.$u.'_'));
	}
	
	public function install()
	{
		return (parent::install() AND 
			$this->registerHook('payment') AND 
			$this->registerHook('orderConfirmation'));
	}
	
	public function getContent()
	{
		if (Tools::isSubmit('submitWorldNetHPP'))
		{
			Configuration::updateValue('WORLDNETHPP_GATEWAY', Tools::getValue('WORLDNETHPP_GATEWAY'));
			Configuration::updateValue('WORLDNETHPP_TEST', (int)Tools::getValue('WORLDNETHPP_TEST'));
			Configuration::updateValue('WORLDNETHPP_CUR1', Tools::getValue('WORLDNETHPP_CUR1'));
			Configuration::updateValue('WORLDNETHPP_TID1', Tools::getValue('WORLDNETHPP_TID1'));
			Configuration::updateValue('WORLDNETHPP_SECRET1', Tools::getValue('WORLDNETHPP_SECRET1'));
			Configuration::updateValue('WORLDNETHPP_CUR2', Tools::getValue('WORLDNETHPP_CUR2'));
			Configuration::updateValue('WORLDNETHPP_TID2', Tools::getValue('WORLDNETHPP_TID2'));
			Configuration::updateValue('WORLDNETHPP_SECRET2', Tools::getValue('WORLDNETHPP_SECRET2'));
			Configuration::updateValue('WORLDNETHPP_SENDADDRESS', (int)Tools::getValue('WORLDNETHPP_SENDADDRESS'));
			Configuration::updateValue('WORLDNETHPP_SENDEMAIL', (int)Tools::getValue('WORLDNETHPP_SENDEMAIL'));
			$dataSync = (($pspid = Configuration::get('WORLDNETHPP_CUR1'))
				? '<img src="http://www.prestashop.com/modules/worldnethpp.png?pspid='.urlencode($pspid).'&mode='.(int)Tools::getValue('WORLDNETHPP_MODE').'" style="float:right" />'
				: ''
			);
			echo $this->displayConfirmation($this->l('Configuration updated').$dataSync);
		}
		
		return '
		<fieldset><legend><img src="../modules/'.$this->name.'/logo.gif" /> '.$this->l('Testing information').'</legend>
			<p>'.$this->l('For test sandbox account details and all other testing information, please visit ').'<b><a href="http://www.worldnettps.com/developers/resources-documentation" target="_blank">'.$this->l('the WorldNet Developers Lounge').'</a></b>.</p>
		</fieldset>
		<div class="clear">&nbsp;</div>
		<form action="'.Tools::htmlentitiesUTF8($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset><legend><img src="../img/admin/contact.gif" /> '.$this->l('Settings').'</legend>
				<label style="width: 400px">'.$this->l('Gateway').'</label>
				<div class="margin-form">
					<select name="WORLDNETHPP_GATEWAY">
						<option value="payments"'.(Configuration::get('WORLDNETHPP_GATEWAY') == 'worldnet' ? ' selected="selected"' : '').'>WorldNet</option>
						<option value="cashflows"'.(Configuration::get('WORLDNETHPP_GATEWAY') == 'cashflows' ? ' selected="selected"' : '').'>CashFlows</option>
					</select>
				</div>
				<label style="width: 400px">'.$this->l('Account Type').'</label>
				<div class="margin-form">
					<span style="display:block;float:left;margin-top:3px;"><input type="radio" id="test" name="WORLDNETHPP_TEST" value="0" style="vertical-align:middle;display:block;float:left;margin-top:2px;margin-right:3px;"
						'.(!Tools::getValue('WORLDNETHPP_TEST', Configuration::get('WORLDNETHPP_TEST')) ? 'checked="checked"' : '').'
					/>
					<label for="test" style="color:#900;display:block;float:left;text-align:left;width:60px;">'.$this->l('Test').'</label>&nbsp;</span>
					<span style="display:block;float:left;margin-top:3px;">
					<input type="radio" id="production" name="WORLDNETHPP_TEST" value="1" style="vertical-align:middle;display:block;float:left; margin-top:2px;margin-right:3px;"
						'.(Tools::getValue('WORLDNETHPP_TEST', Configuration::get('WORLDNETHPP_TEST')) ? 'checked="checked"' : '').'
					/>
					<label for="production" style="color:#080;display:block;float:left;text-align:left;width:85px;">'.$this->l('Production').'</label></span>
				</div>
				<div class="clear">&nbsp;</div>
				<label style="width: 400px">'.$this->l('Primary Terminal Currency').'</label>
				<div class="margin-form">
					<select name="WORLDNETHPP_CUR1">
						<option value="EUR"'.(Configuration::get('WORLDNETHPP_CUR1') == 'EUR' ? ' selected="selected"' : '').'>'.$this->l('Euro').'</option>
						<option value="GBP"'.(Configuration::get('WORLDNETHPP_CUR1') == 'GBP' ? ' selected="selected"' : '').'>'.$this->l('Sterling').'</option>
						<option value="USD"'.(Configuration::get('WORLDNETHPP_CUR1') == 'USD' ? ' selected="selected"' : '').'>'.$this->l('US Dollar').'</option>
					</select>
				</div>
				<label style="width: 400px" for="tid1">'.$this->l('Primary Terminal ID').'</label>
				<div class="margin-form">
					<input type="text" id="tid1" size="20" name="WORLDNETHPP_TID1" value="'.Tools::safeOutput(Tools::getValue('WORLDNETHPP_TID1', Configuration::get('WORLDNETHPP_TID1'))).'" />
				</div>
				<label style="width: 400px" for="secret1">'.$this->l('Shared Secret').'</label>
				<div class="margin-form">
					<input type="text" id="secret1" size="20" name="WORLDNETHPP_SECRET1" value="'.Tools::safeOutput(Tools::getValue('WORLDNETHPP_SECRET1', Configuration::get('WORLDNETHPP_SECRET1'))).'" />
				</div>
				<div class="clear">&nbsp;</div>
				<label style="width: 400px">'.$this->l('Secondary Terminal Currency').'</label>
				<div class="margin-form">
					<select name="WORLDNETHPP_CUR2">
						<option value="EUR"'.(Configuration::get('WORLDNETHPP_CUR2') == 'EUR' ? ' selected="selected"' : '').'>'.$this->l('Euro').'</option>
						<option value="GBP"'.(Configuration::get('WORLDNETHPP_CUR2') == 'GBP' ? ' selected="selected"' : '').'>'.$this->l('Sterling').'</option>
						<option value="USD"'.(Configuration::get('WORLDNETHPP_CUR2') == 'USD' ? ' selected="selected"' : '').'>'.$this->l('US Dollar').'</option>
					</select>
				</div>
				<label style="width: 400px" for="tid2">'.$this->l('Secondary Terminal ID').'</label>
				<div class="margin-form">
					<input type="text" id="tid1" size="20" name="WORLDNETHPP_TID2" value="'.Tools::safeOutput(Tools::getValue('WORLDNETHPP_TID2', Configuration::get('WORLDNETHPP_TID2'))).'" />
				</div>
				<label style="width: 400px" for="secret2">'.$this->l('Shared Secret').'</label>
				<div class="margin-form">
					<input type="text" id="secret2" size="20" name="WORLDNETHPP_SECRET2" value="'.Tools::safeOutput(Tools::getValue('WORLDNETHPP_SECRET2', Configuration::get('WORLDNETHPP_SECRET2'))).'" />
				</div>
				<div class="clear">&nbsp;</div>
				<label style="width: 400px">'.$this->l('Send customers address for verification?').'</label>
				<div class="margin-form">
					<input type="radio" name="WORLDNETHPP_SENDADDRESS" value="1"'.(Tools::safeOutput(Tools::getValue('WORLDNETHPP_SENDADDRESS', Configuration::get('WORLDNETHPP_SENDADDRESS'))) == '1' ? ' checked' : '').'>Yes</input>
					<input type="radio" name="WORLDNETHPP_SENDADDRESS" value="0"'.(Tools::safeOutput(Tools::getValue('WORLDNETHPP_SENDADDRESS', Configuration::get('WORLDNETHPP_SENDADDRESS'))) == '0' ? ' checked' : '').'>No</input>
				</div>
				<div class="clear">&nbsp;</div>
				<label style="width: 400px">'.$this->l('Send WorldNet receipt to customer?').'</label>
				<div class="margin-form">
					<input type="radio" name="WORLDNETHPP_SENDEMAIL" value="1"'.(Tools::safeOutput(Tools::getValue('WORLDNETHPP_SENDEMAIL', Configuration::get('WORLDNETHPP_SENDEMAIL'))) == '1' ? ' checked' : '').'>Yes</input>
					<input type="radio" name="WORLDNETHPP_SENDEMAIL" value="0"'.(Tools::safeOutput(Tools::getValue('WORLDNETHPP_SENDEMAIL', Configuration::get('WORLDNETHPP_SENDEMAIL'))) == '0' ? ' checked' : '').'>No</input>
				</div>
				<div class="clear">&nbsp;</div>
				<input type="submit" name="submitWorldNetHPP" value="'.$this->l('Update settings').'" class="button" />
			</fieldset>
		</form>
		<div class="clear">&nbsp;</div>';
	}
	
	public function getIgnoreKeyList()
	{
		return $this->_ignoreKeyList;
	}
	
	public function hookPayment($params)
	{
		global $smarty;
		
		$currency = new Currency((int)($params['cart']->id_currency));
		$lang = new Language((int)($params['cart']->id_lang));
		$customer = new Customer((int)($params['cart']->id_customer));
		$address = new Address((int)($params['cart']->id_address_invoice));
		$country = new Country((int)($address->id_country), (int)($params['cart']->id_lang));
		$postParams = array();
		
		if($currency->iso_code == Configuration::get('WORLDNETHPP_CUR1')) {
			$postParams['TERMINALID'] = Configuration::get('WORLDNETHPP_TID1');
			$sharedSecret = Configuration::get('WORLDNETHPP_SECRET1');
		} else {
			$postParams['TERMINALID'] = Configuration::get('WORLDNETHPP_TID2');
			$sharedSecret = Configuration::get('WORLDNETHPP_SECRET2');
		}
		
		$postParams['ORDERID'] = pSQL($params['cart']->id);
		$postParams['CURRENCY'] = $currency->iso_code;
		$postParams['AMOUNT'] = number_format(Tools::convertPrice((float)(number_format($params['cart']->getOrderTotal(true, Cart::BOTH), 2, '.', '')), $currency), 2, '.', '');
		$postParams['DATETIME'] = date('d-m-Y:H:i:s:000');
		$postParams['LANGUAGE'] = $lang->iso_code.'_'.strtoupper($lang->iso_code);
		$postParams['CARDHOLDERNAME'] = $customer->firstname . ' ' . $customer->lastname;
		if(Configuration::get('WORLDNETHPP_SENDEMAIL') == '1') $postParams['EMAIL'] = $customer->email;
		if(Configuration::get('WORLDNETHPP_SENDADDRESS') == '1') {
			$postParams['ADDRESS1'] = $address->address1;
			$postParams['ADDRESS2'] = $address->address2;
			$postParams['POSTCODE'] = $address->postcode;
		}
		$postParams['RECEIPTPAGEURL'] = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/worldnethpp/confirmation.php';
		$postParams['VALIDATIONURL'] = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/worldnethpp/validation.php';
		$postParams['PRESTASHOPSECUREKEY'] = $params['cart']->secure_key;
		$postParams['HASH'] = md5($postParams['TERMINALID'] . $postParams['ORDERID'] . $postParams['AMOUNT'] . $postParams['DATETIME'] . $postParams['RECEIPTPAGEURL'] . $postParams['VALIDATIONURL'] . $sharedSecret);
		if (!empty($address->phone)) $postParams['OWNERTELNO'] = $address->phone;
		ksort($postParams);
		
		$smarty->assign('worldnet_params', $postParams);
		$smarty->assign('WORLDNETHPP_GATEWAY', Configuration::get('WORLDNETHPP_GATEWAY'));
		$smarty->assign('WORLDNETHPP_TEST', Configuration::get('WORLDNETHPP_TEST'));
		$smarty->assign('worldnet_link', Tools::getHttpHost(true).'order-confirmation.php?id_cart='.(int)($id_cart).'&id_module='.(int)($this->id).'&id_order='.(int)($this->currentOrder).'&key='.$order->secure_key);
	      //$smarty->assign('worldnet_link', (method_exists($link, 'getPageLink') ? $link->getPageLink('order-confirmation.php', true) : Tools::getHttpHost(true).'order-confirmation.php')).'?id_cart='.(int)($id_cart).'&id_module='.(int)($this->id).'&id_order='.(int)($this->currentOrder).'&key='.$order->secure_key;
		
		return $this->display(__FILE__, 'worldnethpp.tpl');
    }
	
	public function hookOrderConfirmation($params)
	{
		global $smarty, $cookie;
		
		if ($params['objOrder']->module != $this->name)
			return;
		
		if ($params['objOrder']->valid)
			$smarty->assign(array('status' => 'ok', 'id_order' => $params['objOrder']->id));
		else
			$smarty->assign('status', 'failed');
		$link = new Link();
		$smarty->assign('worldnet_link', (method_exists($link, 'getPageLink') ? $link->getPageLink('contact-form.php', true) : Tools::getHttpHost(true).'contact-form.php'));
		return $this->display(__FILE__, 'hookorderconfirmation.tpl');
	}
	
	public function validate($id_cart, $id_order_state, $amount, $message = '', $secure_key)
	{
		$this->validateOrder((int)$id_cart, $id_order_state, $amount, $this->displayName, $message, NULL, NULL, true, pSQL($secure_key));
		if ($amount > 0 AND file_exists('../../classes/PaymentCC.php'))
		{
			$pcc = new PaymentCC();
			$order = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'orders WHERE id_cart = '.(int)$id_cart);
			$pcc->id_order = (int)$order['id_order'];
			$pcc->id_currency = (int)$order['id_currency'];
			$pcc->amount = $amount;
			$pcc->transaction_id = Tools::getValue('PAYID');
			$pcc->card_number = Tools::getValue('CARDNO');
			$pcc->card_brand = Tools::getValue('BRAND');
			$pcc->card_expiration = Tools::getValue('ED');
			$pcc->card_holder = Tools::getValue('CN');
			$pcc->add();
		}
	}
}
