<?php

/*
Plugin Name: Zencart WorldNet Secure Payments (redirect)
Plugin URI: http://www.worldnettps.com/
Description: Extends Zencart with WorldNet TPS Hosted Payment Page redirect gateway.
Version: 1.4
Copyright: © 2009-2016 WorldNet TPS.
License: GNU General Public License v3.0
License URI: http://www.gnu.org/licenses/gpl-3.0.html
*/

/*  Copyright 2016  WorldNEt TPS  (email: support@worldnettps.com)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


class worldnet_hpp
{
  var $code, $title, $description, $enabled;
  var $oid;

  function worldnet_hpp()
  {
    global $order;

    $this->code        = 'worldnet_hpp';
    $this->title       = MODULE_PAYMENT_WORLDNETHPP_TEXT_TITLE;
    $this->description = MODULE_PAYMENT_WORLDNETHPP_TEXT_DESCRIPTION;
    $this->sort_order  = MODULE_PAYMENT_WORLDNETHPP_SORT_ORDER;
    $this->enabled     = ((MODULE_PAYMENT_WORLDNETHPP_STATUS == 'True') ? true : false);
    $this->pci         = true;

    if( (int)MODULE_PAYMENT_WORLDNETHPP_ORDER_STATUS_ID > 0 )
    {
      $this->order_status = MODULE_PAYMENT_WORLDNETHPP_ORDER_STATUS_ID;
    }

    if(is_object($order))
      $this->update_status();

    $this->form_action_url = "https://" . (MODULE_PAYMENT_WORLDNETHPP_TEST_MODE == "Yes" ? "test" : "");

switch (strtolower(MODULE_PAYMENT_WORLDNETHPP_GATEWAY)) {
					default :
					case 'worldnet'  : $this->form_action_url .= 'payments.worldnettps.com'; break;
					case 'cashflows' : $this->form_action_url .= 'cashflows.worldnettps.com'; break;
					case 'payius'    : $this->form_action_url .= 'payments.payius.com' ; break;
					case 'pagotechnology'    : $this->form_action_url .= 'payments.pagotechnology.com' ; break;
					case 'globalonepay'    : $this->form_action_url .= 'payments.globalone.me' ; break;
					case 'anywherecommerce'    : $this->form_action_url .= 'payments.anywherecommerce.com' ; break;
					case 'ctpayment'    : $this->form_action_url .= 'payments.ct-payment.com' ; break;
					case 'payzone'    : $this->form_action_url .= 'payment.payzone.ie' ; break;
					case 'payconex'    : $this->form_action_url .= 'gateway.payconex.net' ; break;
				}
          	$this->form_action_url .= '/merchant/paymentpage'; 




  }

  // class methods
  function update_status()
  {
    global $db;
    global $order;

    if( ($this->enabled == true) && ((int)MODULE_PAYMENT_WORLDNETHPP_ZONE > 0) )
    {
      $check_flag = false;
      $check = $db->Execute("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_WORLDNETHPP_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
      while (!$check->EOF)
      {
        if ($check['zone_id'] < 1)
        {
          $check_flag = true;
          break;
        } 
        elseif ($check['zone_id'] == $order->billing['zone_id'])
        {
          $check_flag = true;
          break;
        }
	$check->MoveNext();
      }

      if($check_flag == false)
      {
        $this->enabled = false;
      }
    }
  }

  function javascript_validation()
  {
    return false;
  }

  function selection()
  {
   
    return array( 'id'     => $this->code,
                  'module' => '<img width="400" height="200" src="'.DIR_WS_MODULES.'payment/images/zen_cart_worldnet.png'.'" />');
  }

  function pre_confirmation_check()
  {
    return false;
  }

  function confirmation()
  {
    return false;
  }

  function process_button()
  {
    global $osC_Session, $order, $currencies,$currency;
    
     $currency = $order->info['currency'];
    if ($currency == MODULE_PAYMENT_WORLDNETHPP_CURRENCY_2)
    {
        $my_currency = MODULE_PAYMENT_WORLDNETHPP_CURRENCY_2;
        $terminalid  = MODULE_PAYMENT_WORLDNETHPP_ID_2;
    	$secret      = MODULE_PAYMENT_WORLDNETHPP_SECRET_2;
    }
    elseif($currency == MODULE_PAYMENT_WORLDNETHPP_CURRENCY)
    {
        $my_currency = MODULE_PAYMENT_WORLDNETHPP_CURRENCY;
        $terminalid  = MODULE_PAYMENT_WORLDNETHPP_ID;
    	$secret      = MODULE_PAYMENT_WORLDNETHPP_SECRET;
    }
    else
    { 
         
           die("CART CURRENCY DOESN'T MATCH WITH TERMINAL CURRENCY");
    }

    mt_srand((double)microtime()*1000000);

    $datetime = strftime("%d-%m-%Y:%H:%M:%S").":".mt_rand(1, 999);
    $orderid = strftime("%H%M%S"). mt_rand(100000, 999999);
	$email = $order->customer['email_address'];
    $curr = $my_currency;

    $amount = number_format($order->info['total'] * $currencies->get_value($my_currency), $currencies->get_decimal_places($my_currency), '.', '');
    $receiptPageURL = zen_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL');
    $hash      = md5($terminalid . $orderid . $amount . $datetime . $receiptPageURL . $secret);

    $n=sizeof($order->products);
    $orderString = 'Product Count: ' . $n . '<br /><br />';
    for ($i=0; $i<$n; $i++) {
        $orderString .= 'Product ID: ' . zen_get_prid($order->products[$i]['id']) . '<br />Model: ' . $order->products[$i]['model'] . '<br />Name: ' . $order->products[$i]['name'] . '<br />Quantity: ' . $order->products[$i]['qty'] . '<br />Price: ' . $order->products[$i]['final_price'] . '<br /><br />';
    }


    $process_button_string = zen_draw_hidden_field('TERMINALID',          $terminalid) .
                             zen_draw_hidden_field('SECRET',              $secret) .                             
                             zen_draw_hidden_field('osCsid',              session_id()) .
                             zen_draw_hidden_field('ORDERID',             $orderid) .
                             zen_draw_hidden_field('AMOUNT',              $amount) .
                             zen_draw_hidden_field('CURRENCY',            $curr) .
                             zen_draw_hidden_field('DATETIME',            $datetime) .
                             zen_draw_hidden_field('HASH',                $hash).
                             zen_draw_hidden_field('RECEIPTPAGEURL',      $receiptPageURL).
                             (MODULE_PAYMENT_WORLDNETHPP_SEND_EMAIL == "Yes" ? zen_draw_hidden_field('EMAIL', $email) : "").
                             zen_draw_hidden_field('CARDHOLDERNAME',      urldecode($order->billing['firstname']) . ' ' . urldecode($order->billing['lastname'])).
                             (strlen($order->billing['company']) > 0 ? zen_draw_hidden_field('CUSTOMERCOMPANY', urldecode($order->billing['company'])) : "").
                             zen_draw_hidden_field('ADDRESS1',            $order->billing['street_address'] . ', ' . $order->billing['suburb']).
                             zen_draw_hidden_field('ADDRESS2',            $order->billing['city'] . ', ' . $order->billing['state']).
                             zen_draw_hidden_field('POSTCODE',            $order->billing['postcode']).
                             zen_draw_hidden_field('PHONE',               $order->customer['telephone']).
                             zen_draw_hidden_field('ORDERDETAILS',        htmlspecialchars(preg_replace('/\'/','',preg_replace('/%/','',$orderString))));

    return $process_button_string;
  }

  function after_process()
  {
    global $currency;
    
    
    $error = false;
    

    $terminalid = $_REQUEST['TERMINALID'];
    $secret       = $_REQUEST['SECRET'];
    $orderid      = $_REQUEST['ORDERID']      ;
    $amount       = $_REQUEST['AMOUNT']       ;
    $datetime     = $_REQUEST['DATETIME']     ;
    $result       = $_REQUEST['RESULT']       ;
    
    $message      = $_REQUEST['MESSAGE']      ;
    
    $authcode     = $_REQUEST['AUTHCODE']     ;
    $pasref       = $_REQUEST['PASREF']       ;
    $md5hash_post = $_REQUEST['HASH']         ;
    $RESPONSECODE = $_REQUEST['RESPONSECODE'] ;
    $RESPONSETEXT = $_REQUEST['RESPONSETEXT'] ;
    
    $md5hash_new = md5($terminalid . $orderid . $amount . $datetime . $RESPONSECODE . $RESPONSETEXT . $secret);
    
    //Check to see if hashes match or not
    if ($md5hash_new != $md5hash_post)
    {
      $payment_error_return = 'payment_error=' . $this->code . '&error=' . TEXT_WORLDNETHPP_HASH_ERROR . " - Expected: " . $md5hash_new . " vs " . $md5hash_post."terminalid".$terminalid."secret".$secret."currency".$currency;
      zen_redirect(zen_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
    }

    if($RESPONSECODE != "A")
    {
      $payment_error_return = 'payment_error=' . $this->code . '&error=Bank Response: ' . $RESPONSETEXT;
      zen_redirect(zen_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
    }

    return false;
  }

  function before_process()
  {
    return false;
  }

  function get_error()
  {
    if (PHP_VERSION < 4.1)
    {
      global $_GET;
    }

    $error = array('title' => WORLDNETHPP_ERROR_TITLE,
                   'error' => ((isset($_GET['error'])) ? stripslashes(urldecode($_GET['error'])) : IPAYMENT_ERROR_MESSAGE));

    return $error;
  }

  function output_error()
  {
    return false;
  }

  function check()
  {
    if(!isset($this->_check))
    {
	global $db;
      $check_query = $db->Execute("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_WORLDNETHPP_STATUS'");
      $this->_check = $check_query->RecordCount();
    }
    return $this->_check;
  }

  function install()
  {
	global $db;
    $db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES 
      (
        'Enable WorldNet TPS Module', 
        'MODULE_PAYMENT_WORLDNETHPP_STATUS', 
        'True', 
        'Do you want to accept WorldNet TPS payments?', 
        '6', 
        '1', 
        'zen_cfg_select_option(array(\'True\', \'False\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Gateway',
        'MODULE_PAYMENT_WORLDNETHPP_GATEWAY',
        'WorldNet',
        'Under which WorldNet gateway is your account?',
        '6',
        '2',
        'zen_cfg_select_option(array(\'WorldNet\',\'CashFlows\',\'Payius\',\'PagoTechnology\',\'GlobalOnePay\',\'AnywhereCommerce\',\'CTPayment\',\'Payzone\',\'Payconex\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Test Mode?',
        'MODULE_PAYMENT_WORLDNETHPP_TEST_MODE',
        'Yes',
        'Are you in test or live mode?',
        '6',
        '3',
        'zen_cfg_select_option(array(\'Yes\',\'No\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'First Transaction Currency',
        'MODULE_PAYMENT_WORLDNETHPP_CURRENCY',
        'Selected Currency',
        'The first currency to use for credit card transactions',
        '6',
        '4',
        'zen_cfg_select_option(array(\'EUR\',\'GBP\',\'USD\',\'CAD\',\'AUD\',\'DKK\',\'SEK\',\'DKK\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES
      (
        'First Terminal ID',
        'MODULE_PAYMENT_WORLDNETHPP_ID',
        'TerminalID 1',
        'The Terminal ID provided by WorldNet TPS for the first currency',
        '6',
        '5',
        now())");

    $db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'First Shared Secret', 
        'MODULE_PAYMENT_WORLDNETHPP_SECRET', 
        'Secret', 
        'The Shared Secret provided by WorldNet TPS for the first currency',
        '6', 
        '6',
        now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Second Transaction Currency (if applicable)',
        'MODULE_PAYMENT_WORLDNETHPP_CURRENCY_2',
        'Selected Currency',
        'The second currency to use for credit card transactions',
        '6',
        '7',
        'zen_cfg_select_option(array(\'EUR\',\'GBP\',\'USD\',\'CAD\',\'AUD\',\'DKK\',\'SEK\',\'DKK\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES
      (
        'Second Terminal ID',
        'MODULE_PAYMENT_WORLDNETHPP_ID_2',
        'TerminalID 2',
        'The Terminal ID provided by WorldNet TPS for the second currency',
        '6',
        '8',
        now())");

    $db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'Second Shared Secret', 
        'MODULE_PAYMENT_WORLDNETHPP_SECRET_2', 
        'Secret', 
        'The Shared Secret provided by WorldNet TPS for the second currency',
        '6', 
        '9',
        now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Send receipt from WorldNet TPS host?',
        'MODULE_PAYMENT_WORLDNETHPP_SEND_EMAIL',
        'No',
        'The WorldNet TPS host can send it\'s own non-configurable e-mail that only contains transaction information.',
        '6',
        '10',
        'zen_cfg_select_option(array(\'Yes\',\'No\'), ', now())");

$db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'Sort order of display.', 
        'MODULE_PAYMENT_WORLDNETHPP_SORT_ORDER', 
        '0', 
        'Sort order of display. Lowest is displayed first.', 
        '6', 
        '11',
        now())");
  
    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added)
      VALUES
      (
        'Set Order Status',
        'MODULE_PAYMENT_WORLDNETHPP_ORDER_STATUS_ID',
        '0',
        'Set the status of orders made with this payment module to this value',
        '6',
        '12',
        'zen_cfg_pull_down_order_statuses(', 'zen_get_order_status_name', now())");
  }

  function remove()
  {
	global $db;
    $db->Execute("delete from " . TABLE_CONFIGURATION . " where configuration_key like 'MODULE_PAYMENT_WORLDNETHPP%';");
  }

  function keys()
  {
    return array(
      'MODULE_PAYMENT_WORLDNETHPP_STATUS'              ,
      'MODULE_PAYMENT_WORLDNETHPP_GATEWAY'             ,
      'MODULE_PAYMENT_WORLDNETHPP_TEST_MODE'           ,
      'MODULE_PAYMENT_WORLDNETHPP_CURRENCY'            ,
      'MODULE_PAYMENT_WORLDNETHPP_ID'                  ,
      'MODULE_PAYMENT_WORLDNETHPP_SECRET'              ,
      'MODULE_PAYMENT_WORLDNETHPP_CURRENCY_2'          ,
      'MODULE_PAYMENT_WORLDNETHPP_ID_2'                ,
      'MODULE_PAYMENT_WORLDNETHPP_SECRET_2'            ,
      'MODULE_PAYMENT_WORLDNETHPP_SEND_EMAIL'          ,
      'MODULE_PAYMENT_WORLDNETHPP_ORDER_STATUS_ID'     ,
      'MODULE_PAYMENT_WORLDNETHPP_SORT_ORDER');
  }
}

?>
